<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database credentials
$servername = "localhost";
$username = "cchubin_pro";
$password = "Sacred1234.";
$dbname = "cchubin_pro";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle table selection
$tableName = isset($_GET['table']) ? $conn->real_escape_string($_GET['table']) : null;

// Handle editing a row
if (isset($_POST['edit'])) {
    $id = $conn->real_escape_string($_POST['id']);
    $updateValues = [];

    foreach ($_POST as $key => $value) {
        if (strpos($key, 'value_') === 0) {
            $column = str_replace('value_', '', $key);
            $updateValues[] = "`$column` = '" . $conn->real_escape_string($value) . "'";
        }
    }

    if (!empty($updateValues)) {
        $updateSql = "UPDATE `$tableName` SET " . implode(', ', $updateValues) . " WHERE id = $id";
        
        if ($conn->query($updateSql) === TRUE) {
            echo "<div class='alert alert-success'>Record updated successfully</div>";
        } else {
            echo "<div class='alert alert-danger'>Error updating record: " . $conn->error . "</div>";
        }
    } else {
        echo "<div class='alert alert-warning'>No values to update.</div>";
    }
}

// Handle deletion of a row
if (isset($_POST['delete'])) {
    $id = $conn->real_escape_string($_POST['id']);
    $deleteSql = "DELETE FROM `$tableName` WHERE id = $id";
    
    if ($conn->query($deleteSql) === TRUE) {
        echo "<div class='alert alert-success'>Record deleted successfully</div>";
    } else {
        echo "<div class='alert alert-danger'>Error deleting record: " . $conn->error . "</div>";
    }
}

// Handle insertion of a new row
if (isset($_POST['insert'])) {
    $columns = [];
    $values = [];
    
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'new_value_') === 0) {
            $column = str_replace('new_value_', '', $key);
            $columns[] = "`$column`";
            $values[] = "'" . $conn->real_escape_string($value) . "'";
        }
    }
    
    if (!empty($columns) && !empty($values)) {
        $insertSql = "INSERT INTO `$tableName` (" . implode(', ', $columns) . ") VALUES (" . implode(', ', $values) . ")";
        
        if ($conn->query($insertSql) === TRUE) {
            echo "<div class='alert alert-success'>Record inserted successfully</div>";
        } else {
            echo "<div class='alert alert-danger'>Error inserting record: " . $conn->error . "</div>";
        }
    } else {
        echo "<div class='alert alert-warning'>No values to insert.</div>";
    }
}

// Handle export
if (isset($_POST['export'])) {
    $selectedColumns = isset($_POST['columns']) ? $_POST['columns'] : [];
    
    if (!empty($selectedColumns)) {
        $columnsList = implode(', ', array_map([$conn, 'real_escape_string'], $selectedColumns));
        $exportSql = "SELECT $columnsList FROM `$tableName`";
        $result = $conn->query($exportSql);

        if ($result && $result->num_rows > 0) {
            $filename = $tableName . '_export_' . date('Ymd') . '.csv';
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="' . $filename . '"');

            $output = fopen('php://output', 'w');
            fputcsv($output, $selectedColumns);

            while ($row = $result->fetch_assoc()) {
                fputcsv($output, array_intersect_key($row, array_flip($selectedColumns)));
            }

            fclose($output);
            exit;
        } else {
            echo "<div class='alert alert-warning'>No data found for export</div>";
        }
    } else {
        echo "<div class='alert alert-warning'>No columns selected for export.</div>";
    }
}

// Handle import
if (isset($_POST['import'])) {
    if (isset($_FILES['import_file']) && $_FILES['import_file']['error'] == 0) {
        $file = $_FILES['import_file']['tmp_name'];
        $handle = fopen($file, "r");

        // Skip header if necessary
        fgetcsv($handle); 

        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            // Prepare SQL INSERT statement
            $values = array_map([$conn, 'real_escape_string'], $data);
            $insertSql = "INSERT INTO `$tableName` VALUES (" . implode(', ', array_map(function($val) { return "'$val'"; }, $values)) . ")";
            $conn->query($insertSql);
        }

        fclose($handle);
        echo "<div class='alert alert-success'>Records imported successfully</div>";
    } else {
        echo "<div class='alert alert-danger'>Error uploading file.</div>";
    }
}

// Query to get table names
$tablesResult = $conn->query("SHOW TABLES");

if ($tableName) {
    $dataResult = $conn->query("SELECT * FROM `$tableName`");
    if (!$dataResult) {
        die("<div class='alert alert-danger'>Error retrieving data: " . $conn->error . "</div>");
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Table Editor</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f4f9;
        }
        .container {
            margin-top: 20px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h1, h2 {
            color: #333;
        }
        table {
            width: 100%;
            margin-bottom: 20px;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #007bff;
            color: #fff;
        }
        .form-container input[type='submit'] {
            background-color: #007bff;
            color: #fff;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            margin: 0 5px;
        }
        .form-container input[type='submit']:hover {
            background-color: #0056b3;
        }
        .form-container input[type='text'] {
            width: 100%;
            padding: 8px;
            margin: 4px 0;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Database Table Editor</h1>
        
        <div class="table-list">
            <h2>Select a Table</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>Table Name</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if ($tablesResult && $tablesResult->num_rows > 0) {
                        while($row = $tablesResult->fetch_array()) {
                            $table = $row[0];
                            echo "<tr><td><a href=\"?table=" . urlencode($table) . "\">" . htmlspecialchars($table) . "</a></td></tr>";
                        }
                    } else {
                        echo "<tr><td>No tables found</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <?php if ($tableName && $dataResult): ?>
            <h2>Data for Table: <?php echo htmlspecialchars($tableName); ?></h2>
            <form method="post" class="form-container">
                <table class="table">
                    <thead>
                        <tr>
                            <?php
                            $fields = $dataResult->fetch_fields();
                            foreach ($fields as $field) {
                                echo "<th>" . htmlspecialchars($field->name) . "</th>";
                            }
                            echo "<th>Actions</th>";
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $dataResult->data_seek(0); // Reset pointer for table data
                        while ($row = $dataResult->fetch_assoc()) {
                            echo "<tr>";
                            foreach ($row as $value) {
                                echo "<td>" . htmlspecialchars($value) . "</td>";
                            }
                            echo "<td>
                                <form method='post' class='d-inline'>
                                    <input type='hidden' name='id' value='" . htmlspecialchars($row['id']) . "'>
                                    <input type='submit' name='edit' value='Edit' class='btn btn-primary'>
                                    <input type='submit' name='delete' value='Delete' class='btn btn-danger' onclick=\"return confirm('Are you sure?');\">
                                </form>
                            </td>";
                            echo "</tr>";
                        }
                        ?>
                    </tbody>
                </table>
                <h3>Edit Record</h3>
                <div class="form-group">
                    <label for="id">ID to Edit:</label>
                    <input type="text" name="id" placeholder="Enter ID" required>
                </div>
                <?php
                // Prepare the input fields for each column
                echo "<div class='form-group'>";
                foreach ($fields as $field) {
                    echo "<label>" . htmlspecialchars($field->name) . "</label>";
                    echo "<input type='text' name='value_" . htmlspecialchars($field->name) . "' placeholder='New " . htmlspecialchars($field->name) . "' required>";
                }
                echo "</div>";
                ?>
                <input type="submit" name="edit" value="Update" class="btn btn-success">
            </form>

            <h3>Insert New Record</h3>
            <form method="post" class="form-container">
                <table class="table">
                    <tr>
                        <?php
                        foreach ($fields as $field) {
                            echo "<th><input type='text' name='new_value_" . htmlspecialchars($field->name) . "' placeholder='" . htmlspecialchars($field->name) . "' required></th>";
                        }
                        echo "<th><input type='submit' name='insert' value='Insert' class='btn btn-success'></th>";
                        ?>
                    </tr>
                </table>
            </form>

            <h2>Import Data</h2>
            <form method="post" enctype="multipart/form-data" class="form-container">
                <input type="file" name="import_file" required>
                <input type="submit" name="import" value="Import" class="btn btn-info">
            </form>

            <h2>Export Table Data</h2>
            <form method="post" class="form-container">
                <div class="form-group">
                    <label for="columns">Select Columns for Export:</label>
                    <select multiple name="columns[]" class="form-control" required>
                        <?php
                        $dataResult->data_seek(0); // Reset pointer for column selection
                        foreach ($fields as $field) {
                            echo "<option value='" . htmlspecialchars($field->name) . "'>" . htmlspecialchars($field->name) . "</option>";
                        }
                        ?>
                    </select>
                </div>
                <input type="submit" name="export" value="Export" class="btn btn-warning">
            </form>
        <?php endif; ?>

        <?php $conn->close(); ?>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
